using System;
using Server.Mobiles;
using Server.Items;
using System.Collections;

namespace Server.Mobiles
{
	//[CorpseName( "a giant toad corpse" )]
	public class FireFrog : BaseCreature
	{
		public override WeaponAbility GetWeaponAbility()
		{
			switch (Utility.Random(3))
			{
				default:
					case 0: return WeaponAbility.DoubleStrike;
				case 1: return WeaponAbility.ArmorIgnore;
				case 2: return WeaponAbility.ParalyzingBlow;
			}
		}

		[Constructable]
		public FireFrog() : base(AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4)
		{
			Name = "a fire frog";
			Body = 81;
			BaseSoundID = 0x266;
			Hue = Regions.FireRegion.RandomFireHue;;

			SetStr(300, 400);
			SetDex(106, 115);
			SetInt(100, 200);

			SetHits(1000, 1500);
			SetMana(500);

			SetDamage(10, 25);

			SetDamageType(ResistanceType.Fire, 60);
			SetDamageType(ResistanceType.Physical, 10);
			SetDamageType(ResistanceType.Poison, 30);

			SetResistance(ResistanceType.Physical, 50, 70);
			SetResistance(ResistanceType.Fire, 100);
			SetResistance(ResistanceType.Cold, 20, 30);
			SetResistance(ResistanceType.Poison, 70, 75);
			SetResistance(ResistanceType.Energy, 40, 70);

			SetSkill(SkillName.Anatomy, 80.5);
			SetSkill(SkillName.Meditation, 110.0);
			SetSkill(SkillName.MagicResist, 80.1, 85.0);
			SetSkill(SkillName.Parry, 90.1, 95.1);
			SetSkill(SkillName.Tactics, 100.0);
			SetSkill(SkillName.Wrestling, 90.1, 120.0);

			Fame = 19000;
			Karma = -15000;

			VirtualArmor = 65;
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.UltraRich);
		}

		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override Poison PoisonImmune { get { return Poison.Deadly; } }
		public override int TreasureMapLevel { get { return 5; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp
		public override HideType HideType { get { return HideType.Daemon; } }
		public override int Hides { get { return (this.IsTeragon) ? 10 : 3; } }
		public override FoodType FavoriteFood { get { return FoodType.Fish | FoodType.Meat; } }
		public override bool HasBreath { get { return true; } } // breath enabled

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			if (from == null)
				return;
			if (Utility.RandomDouble() < 0.075)
				Summon(from);

			if (Utility.RandomDouble() < 0.09 && from != null && from != this && this.CanSee(from))
			{
				SpillAcid(TimeSpan.FromSeconds(10), 20, 40, from);
			}

			// teleports to player
			if (from is PlayerMobile && !InRange(from.Location, 4) && Utility.RandomDouble() < 0.07)
			{
				Combatant = from;

				this.MoveToWorld(from.Location, from.Map);
				this.FixedParticles(0x376A, 9, 32, 0x13AF, EffectLayer.Waist);
				this.PlaySound(0x1FE);
			}

			if (Utility.RandomDouble() < 0.075)
			{
				ArrayList targets = new ArrayList();

				foreach (Mobile m in this.GetMobilesInRange(10))
				{
					if (m == null || m.Deleted)
						continue;

					if (m == this || !CanBeHarmful(m))
						continue;

					if (m is BaseCreature && ((BaseCreature)m).Summoned)
						targets.Add(m);
				}

				for (int i = 0; i < targets.Count; ++i)
				{
					Mobile m = (Mobile)targets[i];

					if (m == null || m.Deleted)
						continue;

					m.Kill();
				}
			}
		}

		public override void AlterMeleeDamageTo(Mobile to, ref int damage)
		{
			damage = DecreaseDamage(to, damage);

			if (to is Xanthos.Interfaces.IEvoCreature)
				damage *= 5;
		}

		public void Summon(Mobile from)
		{
			Map map = this.Map;

			if (map == null || from == null)
				return;

			Mobile targ = null;

			if (from is PlayerMobile && from.Map == map)
				targ = from;

			MadSquirrel summon = new MadSquirrel(targ, 1.0);

			if (summon == null)
				return;

			bool validLocation = false;
			Point3D loc = this.Location;

			for (int j = 0; !validLocation && j < 10; ++j)
			{
				int x = X + Utility.Random(3) - 1;
				int y = Y + Utility.Random(3) - 1;
				int z = map.GetAverageZ(x, y);

				if (validLocation = map.CanFit(x, y, this.Z, 16, false, false))
					loc = new Point3D(x, y, Z);
				else if (validLocation = map.CanFit(x, y, z, 16, false, false))
					loc = new Point3D(x, y, z);
			}

			summon.Name = "an explosive frog";
			summon.Body = 81;
			summon.BaseSoundID = 0x266;
			summon.Hue = this.Hue;
			summon.MoveToWorld(loc, map);
		}

		public FireFrog(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}